import boto3
import json
import sys
import time
import base64

FUNCTION="ImageProc"
BUCKET="sdcc2223"

def invoke_function (image):
    payload={"image": image, "bucket" : BUCKET}
    print(payload)

    # Synchronous invocation
    response = client.invoke(
        FunctionName=FUNCTION,
        InvocationType='RequestResponse',
        LogType='Tail',
        Payload=json.dumps(payload),
    )

    status_code = response['StatusCode']
    payload = response['Payload'].read().decode('utf-8')
    log_result = base64.b64decode(response['LogResult']).decode('utf-8')

    print("Status Code: {}".format(status_code))
    print("Payload:\n{}\n---".format(payload))
    print("Log:\n{}\n---".format(log_result))

client = boto3.client('lambda')
invoke_function(sys.argv[1] if len(sys.argv) > 1 else "https://citynews-firenzetoday.stgy.ovh/~media/horizontal-mid/17241467952952/frecce-tricolori-su-firenze-1-2.jpg")
#https://static01.nyt.com/images/2021/09/14/science/07CAT-STRIPES/07CAT-STRIPES-mediumSquareAt3X-v2.jpg
