terraform {
  required_providers {
    aws = {
      source = "hashicorp/aws"
    }
  }
}

provider "aws" {
   region = "eu-central-1"
}

resource "aws_lambda_function" "funResize" {
   function_name = "Resize"

   package_type = "Zip"
   filename = "resize.zip"
   source_code_hash = filebase64sha256("resize.zip")

   runtime = "provided.al2023"
   handler = "resize"
   timeout = 60
   memory_size = 256

   role = aws_iam_role.iam_for_lambda.arn
}

resource "aws_lambda_function" "funCheck" {
   function_name = "Check"

   package_type = "Zip"
   filename = "check.zip"
   source_code_hash = filebase64sha256("check.zip")

   runtime = "provided.al2023"
   handler = "check"
   timeout = 60
   memory_size = 256

   role = aws_iam_role.iam_for_lambda.arn
}

resource "aws_lambda_function" "funGrayscale" {
   function_name = "Grayscale"

   package_type = "Zip"
   filename = "grayscale.zip"
   source_code_hash = filebase64sha256("grayscale.zip")

   runtime = "provided.al2023"
   handler = "grayscale"
   timeout = 60
   memory_size = 256

   role = aws_iam_role.iam_for_lambda.arn
}


resource "aws_iam_role" "iam_for_lambda" {
  name = "iam_for_lambda_image"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "lambda.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}


# See also the following AWS managed policy: AWSLambdaBasicExecutionRole
resource "aws_iam_policy" "lambda_logging" {
  name        = "lambda_logging_image"
  path        = "/"
  description = "IAM policy for logging from a lambda"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": [
        "logs:CreateLogGroup",
        "logs:CreateLogStream",
        "logs:PutLogEvents"
      ],
      "Resource": "arn:aws:logs:*:*:*",
      "Effect": "Allow"
    },
    {
      "Action": [
        "lambda:InvokeFunction"
      ],
      "Resource": "arn:aws:lambda:eu-central-1:227415535924:function:*",
      "Effect": "Allow"
    }
  ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "lambda_logs" {
  role       = aws_iam_role.iam_for_lambda.name
  policy_arn = aws_iam_policy.lambda_logging.arn
}


data "aws_iam_policy" "rekognition_policy" {
  arn = "arn:aws:iam::aws:policy/AmazonRekognitionFullAccess"
}
data "aws_iam_policy" "s3_policy" {
  arn = "arn:aws:iam::aws:policy/AmazonS3FullAccess"
}

resource "aws_iam_role_policy_attachment" "lambda_rek" {
  role       = aws_iam_role.iam_for_lambda.name
  policy_arn = data.aws_iam_policy.rekognition_policy.arn
}

resource "aws_iam_role_policy_attachment" "policyattachs3" {
  role       = aws_iam_role.iam_for_lambda.name
  policy_arn = data.aws_iam_policy.s3_policy.arn
}
