resource "aws_sfn_state_machine" "sfn_state_machine" {
  name     = "my-state-machine"
  role_arn = aws_iam_role.iam_for_sfn.arn

  definition = <<EOF
{
  "Comment": "My State Machine",
  "StartAt": "Validation",
  "States": {
    "Validation": {
      "Type": "Task",
      "Resource": "${aws_lambda_function.funCheck.arn}",
      "Next": "CheckValid"
    },
    "CheckValid": {
      "Type": "Choice",
		"Choices": [
		{
	"Or": [
	{
	"Variable": "$.Image",
	"IsNull": true
	},
	{
	"Variable": "$.Image",
	"StringEquals": ""
	}
	],
	"Next": "FailState"
	}
	],
	"Default": "ParallelRegion"
    },
    "FailState": {
      "Type": "Fail",
      "Cause": "Invalid image.",
      "Error": "ErrorPost"
    },
    "ParallelRegion": {
      "Type": "Parallel",
      "End": true,
      "Branches": [
    {
        "StartAt": "Resize",
        "States": {
          "Resize": {
            "Type": "Task",
            "Resource": "${aws_lambda_function.funResize.arn}",
            "End": true
          }
        }
      },
    {
        "StartAt": "Grayscale",
        "States": {
          "Grayscale": {
            "Type": "Task",
            "Resource": "${aws_lambda_function.funGrayscale.arn}",
            "End": true
          }
        }
      }
      ]
    }
  }
}
EOF
}

resource "aws_iam_role" "iam_for_sfn" {
  name = "iam_for_sfn"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "states.eu-central-1.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_iam_policy" "sfn_policy" {
  name        = "sfn_policy"
  description = "IAM policy for SFN"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
            "Effect": "Allow",
            "Action": [
                "lambda:*"
            ],
            "Resource": "*"
    }
]
}
EOF
}

resource "aws_iam_role_policy_attachment" "policyattach_sfn" {
  role       = aws_iam_role.iam_for_sfn.name
  policy_arn = aws_iam_policy.sfn_policy.arn
}

output "sfn_arn" {
  value = aws_sfn_state_machine.sfn_state_machine.arn
}
