terraform {
  required_providers {
    aws = {
      source  = "hashicorp/aws"
      version = "~> 4.67.0"
    }
  }
}

provider "aws" {
  profile = "default"
  region  = "eu-central-1"
}


variable "my_sec_group" {
	type = string
	default = "sg-0f4d03c766432bf2a"
}
variable "my_subnet" {
	type = string
	default = "subnet-06ddb8d9b5b086724"
}
variable "key_name" {
	type = string
	default = "msinotebook"
}
variable "my_ami" {
	type = string
	default = "ami-0995d77a92295c10f"
}


resource "aws_instance" "example" {
  ami           = var.my_ami   
  instance_type = "t2.micro"
  vpc_security_group_ids = [var.my_sec_group]
  subnet_id              = var.my_subnet
  associate_public_ip_address = true
  tags = {
    Name = "Terraform"
  }
}

