package main

import "fmt"

func receiver(c chan int, d chan bool) {
	for {
		v, ok := <-c
		if ok {
			fmt.Println("Received ", v)
		} else {
			fmt.Println("Received completed")
			//c <- 0 // panic: send on closed channel
			d <- true
			return
		}
	}
}

func main() {
	val := make(chan int)
	done := make(chan bool)
	go receiver(val, done)
	for i := 1; i <= 3; i++ {
		fmt.Println("sending value", i)
		val <- i
	}
	close(val)
	fmt.Println("sent all values")
	//close(val) // panic: close of closed channel
	<-done
}
