package main

import (
	"log"
	"os"
	"time"
)

// Goal: demonstrate that goroutines are terminated when main function exits

func main() {
	f, err := os.Create("./test.txt")
	if err != nil {
		log.Fatal("Cannot write to file", err)
	}
	go func() {
		for {
			f.WriteString("New line created at: " + time.Now().String() + "\n")
			time.Sleep(1 * time.Second) // goroutine waits for 1 second
		}
	}()
	time.Sleep(5 * time.Second) // main waits for 5 seconds
	// writing to file by goroutine will be finished in 5 seconds
	// when main exits
}
