package main

import "fmt"
import "math"

// Define the interface for geometric shapes
type geometry interface {
    area() float64
    perim() float64
}

// Implement the interface on rectangular and circle types
type rect struct {
    width, height float64
}
type circle struct {
    radius float64
}

// To implement an interface in Go, you just need to
// implement all the methods in the interface. 

// Implement area and perim methods on rect
func (r rect) area() float64 {
    return r.width * r.height
}
func (r rect) perim() float64 {
    return 2*r.width + 2*r.height
}

// Implement area and perim methods on circle
func (c circle) area() float64 {
    return math.Pi * c.radius * c.radius
}
func (c circle) perim() float64 {
    return 2 * math.Pi * c.radius
}

// If a variable has an interface type, then you can call
// methods that are in the named interface. Here's a
// generic measure function taking advantage of this
// to work on any geometry
func measure(g geometry) {
    fmt.Println(g)
    fmt.Println(g.area())
    fmt.Println(g.perim())
}
func main() {
    r := rect{width: 3, height: 4}
    c := circle{radius: 5}

    // The circle and rect struct types both implement the
    // geometry interface so you can use instances of these 
    // structs as arguments to measure
    measure(r)
    measure(c)
}