# gorpc_arith - Go RPC example

This Go module demonstrates a simple Go application using **RPC** (Remote Procedure Call) for communication between a **server** and a **client**. The example supports both **TCP** and **HTTP** transport protocols.

## Steps to run it

Follow these instructions to set up and run the Go RPC server and client.

### 1. **Create a Go module**

Before running the server and client, you need to initialize a Go module for dependency management.

- Open your terminal, navigate to your project directory, and run the following commands:

```bash
$ go mod init gorpc_arith
$ go mod tidy
````

### 2. **Start the RPC server (TCP)**

```bash
$ go run server_tcp.go
```

### 3. **Start the RPC client (TCP)**

```bash
$ go run client_tcp.go
```

### 4. **Optional: run RPC server and client over HTTP**

```bash
$ go run server_http.go
$ go run client_http.go
```

---

## What's inside

Here is a breakdown of the files in the project:

* **`server_tcp.go`**: The Go RPC server running over TCP.
* **`client_tcp.go`**: The Go RPC client that communicates with the TCP server.
* **`server_http.go`**: The Go RPC server running over HTTP (optional).
* **`client_http.go`**: The Go RPC client that communicates with the HTTP server (optional).
* **`arith/arith.go`**: Defines the `arith` package with remote functions Multiply and Divide.
