package arith

import "errors"

// Arith service for RPC
type Arith struct{}

// Input arguments
type Args struct {
	A, B int
}

//Result type for Multiply method
type Result int

//Result type for Divide method
type Quotient struct {
	Quo, Rem int
}

// Every method that we want to export must satisfy the conditions:
// (1) the method has two arguments, both exported (or builtin) types
// (2) the method's second argument is a pointer
// (3) the method has return type error

// Arith service has Multiply which takes numbers A and B
// as arguments and returns error or stores product in reply
// The method has two arguments: the first one (Args)
// will be provided by the caller; the second one (Result)
// is what will be returned to the caller and must be a pointer
// The method is exported because the name is capitalized
func (t *Arith) Multiply(args *Args, res *Result) error {
	*res = Result(args.A * args.B)
	return nil
}

// Arith service has Divide which takes numbers A and B
// as arguments and returns error or stores quotient and remainder in reply
func (t *Arith) Divide(args *Args, quo *Quotient) error {
	if args.B == 0 {
		return errors.New("divide by zero")
	}
	quo.Quo = args.A / args.B
	quo.Rem = args.A % args.B
	return nil
}