package main

import (
	"log"
	"net"
	"net/http"
	"net/rpc"

	"gorpc_arith/arith" // Service package path
)

func main() {

	//Create an instance of the struct implementing Arith interface
	arithService := new(arith.Arith)

	// Register the struct with a new RPC server 
	// Only structs implementing Arith can be registered
	server := rpc.NewServer()
	err := server.RegisterName("Arithmetic", arithService)
	if err != nil {
		log.Fatal("Invalid Arith service: ", err)
	}
	// Register HTTP handlers for RPC and debugging
	server.HandleHTTP("/", "/debug")

	// Listen for incoming connections on port 12345
	lis, err := net.Listen("tcp", ":12345")
	if err != nil {
		log.Fatal("Listen error: ", err)
	}
	log.Printf("RPC server listening on port %d", 12345)
	defer lis.Close()

	// Serve RPC requests over HTTP in a separate goroutine
    go func() {
        if err := http.Serve(lis, nil); err != nil {
            log.Fatal("HTTP Serve error: ", err)
        }
    }()

    log.Println("RPC server is now accepting connections concurrently")

    // Block main goroutine indefinitely; can perform other tasks here if needed
    select {}
}
