package main

import (
	"log"
	"net"
	"net/rpc"

	"gorpc_arith/arith" //Path to the package which contains service definition
)

func main() {

	//Create an instance of the struct implementing Arith interface
	arithService := new(arith.Arith)

	// Register the struct with a new RPC server 
	// Only structs implementing Arith can be registered
	server := rpc.NewServer()
	err := server.RegisterName("Arithmetic", arithService)
	if err != nil {
		log.Fatal("Invalid Arith service: ", err)
	}

	// Listen for incoming TCP packets on specified port
	lis, err := net.Listen("tcp", ":12345")
	if err != nil {
		log.Fatal("Listen error:", err)
	}
	log.Printf("RPC server listening on port %s", lis.Addr().String())
	defer lis.Close()

	// Accept requests connections on the listener
	// and serve requests for each incoming connection
	server.Accept(lis)
}
