# Helloworld — A Simple Example Showing Basic gRPC Client and Server

## Prerequisites

- Go 1.20+ installed
- `protoc` (Protocol Buffers compiler) installed
- `protoc-gen-go` and `protoc-gen-go-grpc` plugins installed

## Project structure

```text
helloworld/
├── greeter_client/
│   ├── client.go           # Basic gRPC client
│   ├── client_conc.go      # Client for concurrent RPC requests
├── greeter_server/
│   ├── server.go           # Basic gRPC server
│   ├── server_stateful.go  # Server with in-memory state (counter)
├── helloworld/
│   ├── helloworld.proto    # gRPC service definition
```

## 1. Create `go.mod`

```bash
go mod init helloworld
go mod tidy
```

## 2. Compile the Helloworld Service Definition

```bash
protoc --go_out=. --go_opt=paths=source_relative \
    --go-grpc_out=. --go-grpc_opt=paths=source_relative \
    helloworld/helloworld.proto
```

## 3. Run the gRPC Server

```bash
go run greeter_server/server.go
```

## 4. Run the gRPC Client
From another terminal (or from a different machine — make sure to update the hostname in both client and server code if needed):

```bash
go run greeter_client/client.go
```

You can also pass the name argument like this:

```bash
go run greeter_client/client.go --name=SDCC
```

## Additional Options

To call multiple concurrent RPC requests, use:

```bash
go run greeter_client/client_conc.go
```

To use a server with in-memory state (e.g., a counter), run:

```bash
go run greeter_server/server_stateful.go
```