# Productinfo: A Simple gRPC Example

`productinfo` is a basic example demonstrating a gRPC client and server. The code is also available in Java, allowing you to run a polyglot client and server. For more details, check out the [Java version of this example](https://github.com/grpc-up-and-running/samples/tree/master/ch02).

## Steps to Set Up and Run

### 1. Initialize Go Modules
Create a `go.mod` file for your Go project:

```bash
$ go mod init productinfo
$ go mod tidy
```

### 2. Compile the gRPC Service Definition

Use `protoc` to compile the service definition from the .proto file:

```bash
$ protoc --go_out=. --go_opt=paths=source_relative \
  --go-grpc_out=. --go-grpc_opt=paths=source_relative \
  ecommerce/product_info.proto
```

### 3. Build the gRPC Server in Go

Navigate to the `server` directory and build the gRPC server:

```bash
$ cd server
$ go build -v -o bin/productinfo_server
```

### 4. Build the gRPC Client in Go

Navigate to the `client` directory and build the gRPC client:

```bash
$ cd ../client
$ go build -v -o bin/productinfo_client
```

### 5. Run the gRPC Server and Client

Start the server by running the following command:
```bash
$ cd ..
$ server/bin/productinfo_server
```

### 5. Run the gRPC Server and Client

Start the client by running the following command:
```bash
$ client/bin/productinfo_client
```