# Route Guide: gRPC Example in Go

`route_guide` demonstrates how to use **gRPC Go libraries** to perform different types of RPCs:
- **Unary RPCs**
- **Client streaming**
- **Server streaming**
- **Bidirectional (full-duplex) streaming**

For more information about using gRPC with Go, please refer to the official documentation: 
[https://grpc.io/docs/languages/go/basics/](https://grpc.io/docs/languages/go/basics/)

---

## Service Definition

The definition of the Route Guide service can be found in `routeguide/route_guide.proto`

---

## Steps to Set Up and Run

### 1. Initialize Go Modules
Create a `go.mod` file for your project:

```bash
$ go mod init route_guide
$ go mod tidy
```

## 2. Compile the Route Guide Service Definition

Use `protoc` to generate Go code for gRPC:

```bash
$ protoc --go_out=. --go_opt=paths=source_relative \
    --go-grpc_out=. --go-grpc_opt=paths=source_relative \
    routeguide/route_guide.proto
```

## 3. Run the gRPC server

Start the server with:

```bash
$ go run server/server.go
```

## 4. Run the gRPC client

From another terminal (or another machine — update the hostname in the client and server code if needed):

```bash
$ go run client/client.go
```

## Optional command line flags

Both the server and client accept optional command-line flags.
By default, they run without TLS. To enable TLS, use the `-tls=true` flag:

Run the Server with TLS: 

```bash
$ go run server/server.go -tls=true
```

Run the Client with TLS:

```bash
$ go run client/client.go -tls=true
```
