# Preliminary steps: install RabbitMQ and start a RabbitMQ server on localhost 
# on default port, see https://www.rabbitmq.com/download.html

```bash
$ rabbitmq-server
```

# Install Go AMQP client library

```bash
$ go get github.com/rabbitmq/amqp091-go
```

# Within the rabbitmq-go directory, create the Go module

```bash
$ go mod init rabbitmq-go
$ go mod tidy
```

# Run examples: we run the producer, consumer and RabbitMQ on the same machine.

# You can also run them on different machines, but you need to set up 
# properly the RabbitMQ hostname in the producer and consumer code.

# Run example 1

```bash
$ cd ex1_hello
```

# Run the producer
```bash
$ go run send.go
```

# From another terminal (or machine), run the consumer.
```bash
$ go run receiver.go
```

# You can also run additional producers and consumers. 
# Using multiple consumers, you can see the round-robin distribution 
# of messages among consumers.
# Observe also that message delivery is push-based.

# Run example 2

```bash
$ cd ex2_worker
```

# Run the producer(s) and consumer(s) using the various versions, starting with \_v1
```bash
$ go run new_task_v1.go ..
$ go run worker_v1.go
```

# Run consumer that sends explicit ack after message processing.
```bash
$ go run new_task_v1.go ........
$ go run worker_v2.go
```

# Terminate the consumer using Ctrl+C while it is processing and see
# that the message received by the failed consumer is no longer lost 
# but redelivered by RabbitMQ to another consumer 
# since it was unacknowledged.

# Run the producer(s) and consumer(s) that use a durable queue. 
```bash
$ go run new_task_v3.go ..........
$ go run worker_v3.go
```

# Interrupt RabbitMQ server when the consumer is processing the message, 
# restart it and see what happens.

# Run multiple consumers from different terminals and observe the 
# improved task distribution with respect to v1
```bash
$ go run worker_v4.go
$ go run worker_v4.go
$ go run new_task_v3.go ..........
$ go run new_task_v3.go ..
$ go run new_task_v3.go .
```

# Terminate RabbitMQ node
```bash
$ rabbitmqctl stop
```