import java.io.*;
import java.rmi.Naming;

public class EchoRMIClient {
	
	//Start the RMI client
	public static void main(String[] args)	{

		final int REGISTRYPORT = 1099;
		String registryHost = null;
		String serviceName = "EchoService"; 
		BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in));
		// Check for hostname argument 
		try {
			if (args.length != 1) { 
				System.out.println("Usage: EchoRMIClient <hostname>");
				System.exit(1); 
			}	
			registryHost = args[0];
			
            // Construct a name to use to look up the remote object,
            // using the same name used by EchoRMIServer to bind its remote object to the RMI registry
			String completeName = "rmi://" + registryHost + ":" + REGISTRYPORT + "/" + serviceName;
            // Look up the remote object by name in the server host's RMI registry
			EchoInterface serverRMI = (EchoInterface)Naming.lookup(completeName);

			//Interact with user
			String message, echo;
			System.out.print("Message? ");
			message = stdIn.readLine();
			//Call remote method
			echo = serverRMI.getEcho(message);
			System.out.println("Echo from remote method: "+echo+"\n");
		} // end try
		catch (Exception e) {
			System.err.println("EchoRMIClient exception: ");
			e.printStackTrace(); 
		}
	} // end main
}