import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class EchoRMIServer extends UnicastRemoteObject implements EchoInterface {

	//Constructor
	public EchoRMIServer() throws RemoteException { 
		super(); 
	}
	
	//Implementation of the remote method
	public String getEcho(String echo) throws RemoteException {
        System.out.println("EchoRMIServer: invoked");
        System.out.println("EchoRMIServer: message > " + echo);
		return echo;
	}
	
	public static void main(String[] args) {
		// Register the remote object with the RMI registry
		final int REGISTRYPORT = 1099; 
		// String registryHost = "localhost"; 
		String serviceName = "EchoService";
		try {
			// String completeName = "//" + registryHost + ":" + REGISTRYPORT + "/" + serviceName;
            // Create an instance of the echo server...
            EchoRMIServer serverRMI = new EchoRMIServer();
            Registry registry = LocateRegistry.createRegistry(REGISTRYPORT);
            // ... and bind it with the RMI registry
            registry.bind(serviceName, serverRMI);
			System.out.println("EchoRMIServer bound");
		}
		catch (Exception e) {
			System.err.println("EchoRMIServer exception: ");
			e.printStackTrace(); 
		}
	}
}