import rpyc
import time
import os

# File to monitor
filename = "/tmp/floop.bloop"
if os.path.exists(filename):
    os.remove(filename)

# Open file to monitor
f = open(filename, "wb", buffering=0)

# Connect to RPyC server that monitors file changes
conn = rpyc.connect("localhost", 18871)

# Start background thread that handles incoming asynchronous events from server
# Necessary for receiving callbacks without blocking the client
bgsrv = rpyc.BgServingThread(conn)  

# Define the callback function on client side
# Called by server whenever the monitored file changes
def on_file_changed(oldstat, newstat):
    print("\nfile changed")
    print(f"    old stat: {oldstat}")
    print(f"    new stat: {newstat}")

# Create the file monitor object and pass filename and callback function as arguments
filemon = conn.root.FileMonitor(filename, on_file_changed)  

# Wait for file monitor to check the initial file state before changing it
time.sleep(2)

# Change file size on client and be notified by server about the change
print("\n---> Change file")
f.write(b"loop")  
time.sleep(2)

# Change file size again; server detects the change and calls callback
print("\n---> Change file again")
f.write(b"groop")
time.sleep(2)

# Cleanup
f.close()
filemon.stop() 
bgsrv.stop()    # stop background thread handling server callbacks
conn.close()