import rpyc
import time
import os

# File to monitor
filename = "/tmp/floop.bloop"
if os.path.exists(filename):
    os.remove(filename)

# Open file to monitor
f = open(filename, "wb", buffering=0)

conn = rpyc.connect("localhost", 18871)

# Callback function
def on_file_changed(oldstat, newstat):
    print("\nfile changed")
    print(f"    old stat: {oldstat}")
    print(f"    new stat: {newstat}")

# Create a file monitor and pass callback function as argument
filemon = conn.root.FileMonitor(filename, on_file_changed)  

# Change file size and wait for file monitor to notice the change
# Alternatively, you can change file from terminal
f.write(b"zzzloop")  

# Wait for file monitor to have a look
time.sleep(2)

# Synchronous: callbacks are processed only when conn.poll_all() is explicitly called
# In this case, we use manual polling; no extra thread is needed
conn.poll_all()

# Cleanup
f.close()
filemon.stop()
conn.close()