import rpyc
import os
import time
from threading import Thread

class FileMonitorService(rpyc.Service):
    class exposed_FileMonitor(object): # expose class
        def __init__(self, filename, callback, interval = 1):
            self.filename = filename    # file to monitor
            self.interval = interval    # monitoring interval
            self.last_stat = None
            self.callback = rpyc.async_(callback) # async callback
            self.active = True
            self.thread = Thread(target = self.work)
            self.thread.start()
        def exposed_stop(self): # must be exposed since client calls it remotely
            self.active = False
            self.thread.join()
        def work(self):         # check for file changes
            while self.active:
                stat = os.stat(self.filename) # get status of monitored file 
                if self.last_stat is not None and self.last_stat != stat:
                    self.callback(self.last_stat, stat) # notify client of change
                self.last_stat = stat
                time.sleep(self.interval) # monitor file status periodically

if __name__ == "__main__":
    from rpyc.utils.server import ThreadedServer
    # spawn a thread for each connection
    ThreadedServer(FileMonitorService, port = 18871).start() 